/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CecUpdater;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.ComputerSystemProvUtils;
import com.ibm.hsc.cim.provider.rs6k.DLPARUtils;
import com.ibm.hsc.cim.provider.rs6k.HSCMProvWithRecoveryPlugin;
import com.ibm.hsc.cim.provider.rs6k.HscInfoMethProv;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.cim.provider.rs6k.OpPanelPoller;
import com.ibm.hsc.cim.provider.rs6k.SystemProfUpdater;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ParseResponse;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.RMCUtils;
import com.ibm.hsc.common.util.SendMsgThruRMC;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import com.ibm.websm.diagnostics.IDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.provider.MethodProvider;
import org.snia.wbemcfg.GlobalConfig;

public class AsynchEventHandler
extends HSCMProvWithRecoveryPlugin
implements MethodProvider {
    private static boolean _debug = false;
    private static int CUOD_CPU_CHANGE = 1;
    private static int CUOD_MEM_CHANGE = 2;
    private static int ONOFF_PROC_CHANGE = 1;
    private static int CUOD_HACKING_MSG = 1;
    private static int CUOD_DISPLAY_MSG = 2;
    private static Properties mClassCodeProp = null;
    private static Properties mVendorCodeProp = null;
    private static final Hashtable _cecPartModes;
    private static final int _false = 0;
    private static final int _true = 1;
    private static final int _deactivate = 4;
    private static final int _NOTIFICATION_EVENT = 5;
    public static final int _CONNECTIONLESS_EVENT = 105;
    private static final int _STATE_CONNECTIONLESS = 254;
    public static final int _CONNECTIONLESS_BYTE = 4;
    private static final float _PART_MODE_VERSION = 2.0f;
    private static final String _CSP_VERSION = "CSPVersion";
    private static final String _PARTITION_TYPE = "PartitionType";
    private static final String _PARTITION_STATE = "PartitionState";
    private static final String _FMP_SLOT = "000";
    private static final String _CEC_MODE = "Mode";

    public static void addPartModeTable(String string, Integer n) {
        _cecPartModes.put(string, n);
    }

    public static void delPartModeTable(String string, Integer n) {
        _cecPartModes.remove(string);
    }

    public AsynchEventHandler() {
        super(false, null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        String string2 = this._getCecName(cIMObjectPath);
        System.out.println("======== AsynchEventHandler: " + string + "  cecName: " + string2);
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
        try {
            hscCecLock.Lock(hscLockManager.getLockType(string));
            CIMValue cIMValue = super.invokeMethod(cIMObjectPath, string, vector, vector2);
            Object var10_9 = null;
            hscCecLock.Unlock();
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            hscCecLock.Unlock();
            throw throwable;
        }
    }

    public CIMValue invokeMethod0(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        int n;
        Object e;
        Hashtable hashtable = null;
        int n2 = -1;
        Object var7_7 = null;
        byte[] byArray = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.invokeMethod");
        }
        CIMValue cIMValue = (e = vector.elementAt(0)) instanceof CIMValue ? (CIMValue)e : ((CIMProperty)e).getValue();
        byArray = (byte[])cIMValue.getValue();
        if (GlobalConfig.debugLevel((int)6) > 0) {
            n = byArray.length;
            System.out.print("     received packet (in hex):[");
            int n3 = 0;
            while (n3 < n) {
                System.out.print(Integer.toHexString(byArray[n3]) + ",");
                ++n3;
            }
            System.out.println("] total bytes: " + n);
        }
        n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append(Integer.toHexString(byArray[n4])).append(",");
            ++n4;
        }
        Trace.trace("apevnhscT", stringBuffer.toString());
        String string2 = this._getCspVersion(cIMObjectPath);
        if (byArray[4] == 105) {
            n2 = 105;
        } else {
            hashtable = this._readAPacket(byArray, string2);
            if (hashtable == null) {
                return new CIMValue((Object)new UnsignedInt8(0));
            }
            try {
                n2 = (Integer)hashtable.get("EVENT_TYPE");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                throwable.printStackTrace();
                return new CIMValue((Object)new UnsignedInt8(0));
            }
        }
        System.out.println("EVENT TYPE = " + n2);
        switch (n2) {
            case 105: {
                this._connectionlessEvent(cIMObjectPath);
                break;
            }
            case 0: {
                this.broadcastEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 1: {
                this.lparEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 2: {
                this.cecEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 3: {
                if (this._isCSPV1V2(cIMObjectPath)) {
                    this.hardwareEvent(hashtable, cIMObjectPath, string2);
                    break;
                }
                this.hardwareCpu30(hashtable, cIMObjectPath, string2);
                break;
            }
            case 4: {
                this.hscInfoClearEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 5: {
                this.hardwareMemory30(hashtable, cIMObjectPath, string2);
                break;
            }
            case 6: {
                this.hardwareSlot30(hashtable, cIMObjectPath, string2);
                break;
            }
            case 7: {
                this.cuodCapacityEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 12: {
                this.onoffCapacityEvent(hashtable, cIMObjectPath, string2);
                break;
            }
            case 11: {
                this.displayMessage(hashtable, cIMObjectPath, string2);
            }
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _connectionlessEvent(CIMObjectPath cIMObjectPath) {
        int n = -1;
        int n2 = -1;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMValue cIMValue = null;
        Object var7_7 = null;
        Object var8_8 = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._connectionlessEvent");
        }
        String string = this._getCecName(cIMObjectPath);
        n2 = 254;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("     newCecState passed in is " + n2);
        }
        try {
            try {
                OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string);
                opPanelPoller.setAllNoPoll();
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                n = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).intValue();
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("    oldCecState is " + n);
                }
                if (n == n2) {
                    return;
                }
                cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n2));
                cIMInstance2.setProperty("State", cIMValue);
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                return;
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                throwable.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hscInfoClearEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        boolean bl = false;
        System.out.println("enter hscInfoClearEvent");
        try {
            String string2 = this._getCecName(cIMObjectPath);
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            System.out.println("after clearNotification");
            String string3 = HscInfoMethProv.constructHscInfo(this.mCIMOMHandle, string2);
            System.out.println("++++++ push hsc info down to CSP: " + string3);
            Hashtable hashtable2 = HscProviderUtils.doCSPCommand("GET_NUMBER_HSC_INFO_SLOTS", null, hscProviderSocket);
            Integer n = (Integer)hashtable2.get("CURRENT_HSC_SLOT");
            System.out.println("slotID: " + n);
            bl = this.lockCsp(hscProviderSocket, 10);
            HscProviderUtils.doCSPCommand("SET_HSC_INFORMATION", new String[]{Integer.toHexString(n), Integer.toHexString(0), Integer.toString(string3.length()), string3}, hscProviderSocket);
            Exception exception = new Exception(string3);
            HSCLogUtils.serverLog(exception, HSCLogUtils._HSCInfoClassLogInfo);
            System.out.println("after write HSCInfo to csp");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    private void broadcastEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) throws CIMException {
        int n = -1;
        String string2 = null;
        Object var6_6 = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastEvent");
        }
        if ((string2 = (String)hashtable.get("OWNER")).equals(HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle))) {
            return;
        }
        n = (Integer)hashtable.get("RESOURCE");
        System.out.println("resource: " + n);
        switch (n) {
            case 1: {
                this.broadcastCec(hashtable, cIMObjectPath, string);
                break;
            }
            case 2: {
                this.broadcastLpar(hashtable, cIMObjectPath, string);
                break;
            }
            case 4: {
                this.broadcastLparProfile(hashtable, cIMObjectPath, string);
                break;
            }
            case 8: {
                this.broadcastSysProfile(hashtable, cIMObjectPath, string);
            }
        }
    }

    public void removeAssociation(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string, "root/ibmhscV3_2");
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMObjectPath, null);
        if (vector == null || vector.size() < 1) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)vector.elementAt(n);
            CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lparEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket;
        block36: {
            block33: {
                int n = -1;
                int n2 = -1;
                int n3 = -1;
                int n4 = -1;
                CIMInstance cIMInstance = null;
                CIMInstance cIMInstance2 = null;
                CIMValue cIMValue = null;
                Hashtable hashtable2 = null;
                hscProviderSocket = null;
                CIMObjectPath cIMObjectPath2 = null;
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("In AsynchEventHandler.lparEvent");
                }
                String string2 = this._getCecName(cIMObjectPath);
                NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
                n = (Integer)hashtable.get("LPAR_ID");
                cIMObjectPath2 = this._slot2cop(n, string2);
                n3 = (Integer)hashtable.get("LPAR_STATE");
                System.out.println("     newLparState passed in is " + n3);
                try {
                    try {
                        OpPanelPoller opPanelPoller;
                        Integer n5;
                        block35: {
                            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                            String string3 = Integer.toHexString(n);
                            if (cIMInstance == null) {
                                hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_SLOT_DEFINITION_STATE", new String[]{string3}, hscProviderSocket, string);
                                int n6 = (Integer)hashtable2.get("DEFINITION_STATE");
                                if (n6 == 4) {
                                    cIMInstance2 = this._addCimLpar((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string2, n, cIMObjectPath2, nVRAM, hscProviderSocket, string);
                                    Integer n7 = (Integer)_cecPartModes.get(string2);
                                    if (n7 != null) {
                                        n4 = n7;
                                    }
                                    if (n4 == -1 || n4 == 0) {
                                        this._updateAvailState((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string2, cIMObjectPath2, hscProviderSocket, string);
                                        cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                                    }
                                    AsynchEventManager.sendIndication(1, cIMInstance2, null);
                                }
                                Object var21_28 = null;
                                if (hscProviderSocket == null) return;
                                hscProviderSocket.releaseLock();
                                return;
                            }
                            n2 = ((UnsignedInt8)cIMInstance.getProperty(_PARTITION_STATE).getValue().getValue()).intValue();
                            System.out.println("     oldLparState is " + n2);
                            hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", new String[]{string3}, hscProviderSocket, string);
                            n3 = (Integer)hashtable2.get("LPAR_STATE");
                            System.out.println("     newLparState in CSP is " + n3);
                            if (n2 == n3 && n3 != 12) {
                                Integer n8 = (Integer)_cecPartModes.get(string2);
                                if (n8 != null) {
                                    n4 = n8;
                                }
                                if (n4 == -1 || n4 == 0) {
                                    this._updateAvailState((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string2, null, hscProviderSocket, string);
                                }
                                break block33;
                            }
                            cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                            cIMValue = new CIMValue((Object)new UnsignedInt8((short)n3));
                            cIMInstance2.setProperty(_PARTITION_STATE, cIMValue);
                            if (n3 == 8 || n3 == 5) {
                                block34: {
                                    try {
                                        hashtable2 = null;
                                        hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{string3}, hscProviderSocket, string);
                                        long l = (Long)hashtable2.get("TOT_ALLOC_MEMORY");
                                        cIMInstance2.setProperty("AllocatedMemory", new CIMValue((Object)new UnsignedInt32(l)));
                                    }
                                    catch (Throwable throwable) {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        if (GlobalConfig.debugLevel((int)6) <= 0) break block34;
                                        throwable.printStackTrace();
                                    }
                                }
                                try {
                                    if (hashtable2 != null) {
                                        long l = (Long)hashtable2.get("PAGE_TABLE_ALLOC_MEMORY");
                                        cIMInstance2.setProperty("PageTableMemory", new CIMValue((Object)new UnsignedInt32(l)));
                                    }
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    if (GlobalConfig.debugLevel((int)6) <= 0) break block35;
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        CIMInstance cIMInstance3 = null;
                        if (n3 == 12) {
                            try {
                                cIMInstance3 = this._handleErrState(cIMInstance2, n, hscProviderSocket, string);
                            }
                            catch (Throwable throwable) {
                                if (GlobalConfig.debugLevel((int)6) > 0) {
                                    throwable.printStackTrace();
                                }
                                try {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                            }
                            if (cIMInstance3 != null) {
                                cIMInstance2 = cIMInstance3;
                            }
                        }
                        if ((n5 = (Integer)_cecPartModes.get(string2)) != null) {
                            n4 = n5;
                        }
                        if (n4 == -1 || n4 == 0) {
                            this._updateAvailState((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string2, cIMObjectPath2, hscProviderSocket, string);
                        }
                        if (n3 == 1 || n3 == 13 || n3 == 252) {
                            opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string2);
                            opPanelPoller.setMaxPollFreq(n, -1);
                            cIMValue = new CIMValue((Object)new UnsignedInt32(0L));
                            cIMInstance2.setProperty("AllocatedMemory", cIMValue);
                            cIMInstance2.setProperty("OpPanelValue", new CIMValue((Object)" "));
                        } else if (n3 == 8 || n3 == 5 || n3 == 9 || n3 == 12) {
                            opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string2);
                            opPanelPoller.setMaxPollFreq(n, 60);
                        }
                        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance2);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            opPanelPoller = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                            System.out.println("    realInst = " + opPanelPoller);
                            System.out.println("    newLparInst = " + cIMInstance2);
                        }
                        System.out.println("before send out lpar modify indication event");
                        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                        break block36;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            throwable.printStackTrace();
                        }
                        Object var21_31 = null;
                        if (hscProviderSocket == null) return;
                        hscProviderSocket.releaseLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var21_32 = null;
                    if (hscProviderSocket == null) throw throwable;
                    hscProviderSocket.releaseLock();
                    throw throwable;
                }
            }
            Object var21_29 = null;
            if (hscProviderSocket == null) return;
            hscProviderSocket.releaseLock();
            return;
        }
        Object var21_30 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cecEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket;
        block51: {
            block49: {
                block48: {
                    int n = -1;
                    int n2 = -1;
                    CIMInstance cIMInstance = null;
                    CIMInstance cIMInstance2 = null;
                    CIMInstance cIMInstance3 = null;
                    CIMInstance cIMInstance4 = null;
                    CIMValue cIMValue = null;
                    CIMObjectPath cIMObjectPath2 = null;
                    Hashtable hashtable2 = null;
                    hscProviderSocket = null;
                    short s = -1;
                    System.out.println("In AsynchEventHandler.cecEvent");
                    String string2 = this._getCecName(cIMObjectPath);
                    NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
                    n2 = (Integer)hashtable.get("CEC_STATE");
                    System.out.println("     newCecState passed in is " + n2);
                    try {
                        try {
                            block50: {
                                short s2;
                                int n3;
                                Object object;
                                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                                n = ((UnsignedInt8)cIMInstance.getProperty("State").getValue().getValue()).intValue();
                                System.out.println("    oldCecState is " + n);
                                if (n == n2 && n2 != 12) {
                                    Object var23_17 = null;
                                    if (hscProviderSocket == null) return;
                                    hscProviderSocket.releaseLock();
                                    return;
                                }
                                hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket, string);
                                n2 = (Integer)hashtable2.get("CEC_STATE");
                                if (n2 == 3 || n2 == 1 || n2 == 12 || n2 == 6) {
                                    System.out.println("stop OpPanel puller");
                                    object = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string2);
                                    ((OpPanelPoller)object).setMaxPollFreq(0, 60);
                                    if (n2 == 3) {
                                        System.out.println("still pulling cec state");
                                        ((OpPanelPoller)object).setAllNoPollButCec();
                                    }
                                } else if (n2 == 254) {
                                    object = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string2);
                                    ((OpPanelPoller)object).setMaxPollFreq(0, -1);
                                    cIMInstance.setProperty("OpPanelValue", new CIMValue((Object)"CANNOT_GET_LED"));
                                }
                                if (GlobalConfig.debugLevel((int)6) > 0) {
                                    System.out.println("     newCecStat from CSP is " + n2);
                                }
                                if (n == n2 && n2 != 12) {
                                    break block48;
                                }
                                object = HscProviderUtils.getCapabilities(string, hscProviderSocket);
                                s = (short)((Integer)((Hashtable)object).get("CecMode")).intValue();
                                if (n2 == 1 && s == 255) {
                                    CecUpdater cecUpdater = new CecUpdater((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance, 2);
                                    cecUpdater.update(hscProviderSocket);
                                    break block49;
                                }
                                cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n2));
                                cIMInstance2.setProperty("State", cIMValue);
                                if (n2 == 3) {
                                    System.out.println("reset cec capability");
                                    n3 = (Integer)((Hashtable)object).get("CecCapability");
                                    cIMInstance2.setProperty("Capability", new CIMValue((Object)new UnsignedInt16((int)((short)n3))));
                                    if (!this._isCSPV1V2(cIMObjectPath)) {
                                        cIMInstance2.setProperty("RuntimeCapability", new CIMValue((Object)new UnsignedInt16(0)));
                                        cIMInstance2.setProperty("CUoDCapabilities", new CIMValue((Object)new UnsignedInt16(0)));
                                    }
                                } else if (n2 == 8 || n2 == 1 || n2 == 12) {
                                    n3 = 0;
                                    s2 = 0;
                                    int n4 = (Integer)((Hashtable)object).get("CecCapability");
                                    cIMInstance2.setProperty("Capability", new CIMValue((Object)new UnsignedInt16((int)((short)n4))));
                                    if (!this._isCSPV1V2(cIMObjectPath)) {
                                        try {
                                            n3 = (short)((Integer)((Hashtable)object).get("RuntimeCapability")).intValue();
                                            if ((n3 & 0x40) != 0) {
                                                hashtable2 = HscProviderUtils.doCSPCommand("GET_CUOD_CAPABILITIES", null, hscProviderSocket, string);
                                                s2 = ((Integer)hashtable2.get("CUOD_CAPABILITIES")).shortValue();
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            throwable.printStackTrace();
                                        }
                                        cIMInstance2.setProperty("RuntimeCapability", new CIMValue((Object)new UnsignedInt16(n3)));
                                        cIMInstance2.setProperty("CUoDCapabilities", new CIMValue((Object)new UnsignedInt16((int)s2)));
                                    }
                                }
                                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                                if (n2 == 3) {
                                    System.out.println("set partition states to not available");
                                    this._updateCecLparState(cIMObjectPath, (short)252, true);
                                    _cecPartModes.put(string2, new Integer(-1));
                                    System.out.println("finish setting  partition states to not available");
                                }
                                if (n2 != 3) {
                                    try {
                                        cIMValue = new CIMValue((Object)new UnsignedInt8(s));
                                        cIMInstance2.setProperty(_CEC_MODE, cIMValue);
                                        String[] stringArray = new String[]{Integer.toHexString(1)};
                                        hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_POLICY_SETTINGS", stringArray, hscProviderSocket, string);
                                        s2 = ((Integer)hashtable2.get("POWER_POLICY")).shortValue();
                                        cIMValue = s2 == 0 ? CIMValue.FALSE : CIMValue.TRUE;
                                        cIMInstance2.setProperty("PowerOffPolicy", cIMValue);
                                    }
                                    catch (Throwable throwable) {
                                        throwable.printStackTrace();
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        if (GlobalConfig.debugLevel((int)6) <= 0) break block50;
                                        throwable.printStackTrace();
                                    }
                                }
                            }
                            if (n2 == 1) {
                                ComputerSystemProvUtils.updateCecResources(hscProviderSocket, cIMObjectPath, cIMInstance2, (CIMOMHandle)this.mCIMOMHandle);
                            }
                            if ((n2 == 6 || n2 == 1) && s == 0) {
                                try {
                                    cIMObjectPath2 = this._slot2cop(0, string2);
                                    cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                                    cIMInstance4 = n2 == 1 ? this._updateOneLparState(cIMInstance3, (short)8) : this._updateOneLparState(cIMInstance3, (short)5);
                                }
                                catch (Throwable throwable) {
                                    if (GlobalConfig.debugLevel((int)6) > 0) {
                                        throwable.printStackTrace();
                                    }
                                    try {
                                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    }
                                    catch (Throwable throwable2) {
                                        // empty catch block
                                    }
                                }
                                _cecPartModes.put(string2, new Integer(-1));
                                if (cIMInstance4 != null) {
                                    AsynchEventManager.sendIndication(4, cIMInstance4, cIMInstance3);
                                }
                            }
                            if (n2 == 12) {
                                this._updateCecLparState(cIMObjectPath, (short)252, false);
                                if (s == 0) {
                                    cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Partition"), false);
                                    try {
                                        cIMInstance4 = this._handleErrState(cIMInstance3, 0, hscProviderSocket, string);
                                    }
                                    catch (Throwable throwable) {
                                        if (GlobalConfig.debugLevel((int)6) > 0) {
                                            throwable.printStackTrace();
                                        }
                                        try {
                                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                        catch (Throwable throwable3) {
                                            // empty catch block
                                        }
                                    }
                                    if (cIMInstance4 != null) {
                                        cIMInstance3 = cIMInstance4;
                                    }
                                    try {
                                        cIMObjectPath2 = this._slot2cop(0, string2);
                                        cIMInstance4 = this._updateOneLparState(cIMInstance3, (short)12);
                                    }
                                    catch (Throwable throwable) {
                                        if (GlobalConfig.debugLevel((int)6) > 0) {
                                            throwable.printStackTrace();
                                        }
                                        try {
                                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                        }
                                        catch (Throwable throwable4) {
                                            // empty catch block
                                        }
                                    }
                                    _cecPartModes.put(string2, new Integer(-1));
                                    if (cIMInstance4 != null) {
                                        AsynchEventManager.sendIndication(4, cIMInstance4, cIMInstance3);
                                    }
                                }
                            }
                            System.out.println("set cec instance " + cIMInstance2);
                            CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                            System.out.println("send out cec state change indication");
                            AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                            break block51;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            if (GlobalConfig.debugLevel((int)6) > 0) {
                                throwable.printStackTrace();
                            }
                            Object var23_21 = null;
                            if (hscProviderSocket == null) return;
                            hscProviderSocket.releaseLock();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var23_22 = null;
                        if (hscProviderSocket == null) throw throwable;
                        hscProviderSocket.releaseLock();
                        throw throwable;
                    }
                }
                Object var23_18 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
            Object var23_19 = null;
            if (hscProviderSocket == null) return;
            hscProviderSocket.releaseLock();
            return;
        }
        Object var23_20 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void hardwareCpu30(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket = null;
        System.out.println("in hardwareCpu30");
        try {
            try {
                Vector vector;
                String string2;
                block10: {
                    block9: {
                        string2 = this._getCecName(cIMObjectPath);
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                        vector = (Vector)hashtable.get("PROC_LIST");
                        if (vector == null) break block9;
                        if (vector.size() >= 1) break block10;
                    }
                    Object var16_8 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                Vector vector2 = this.getAllCpuStates(hscProviderSocket, string);
                Vector vector3 = this.getAllCpuStatus(hscProviderSocket, string);
                Vector vector4 = this.getAllCpuAssignment(hscProviderSocket, string);
                int n = 0;
                while (n < vector.size()) {
                    int n2 = (Integer)vector.elementAt(n);
                    int n3 = (Integer)vector2.elementAt(n2);
                    int n4 = (Integer)vector3.elementAt(n2);
                    int n5 = (Integer)vector4.elementAt(n2);
                    this.procOncCPUChange(cIMObjectPath, string2, n2, n3, n4, n5, string, hscProviderSocket);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                throwable.printStackTrace();
                Object var16_10 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_11 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var16_9 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    protected void resetCpuStateStatue(int n, int n2, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMValue cIMValue = null;
        boolean bl = false;
        int n3 = ((UnsignedInt8)cIMInstance.getProperty("CPUState").getValue().getValue()).intValue();
        int n4 = ((UnsignedInt8)cIMInstance.getProperty("CPUStatus").getValue().getValue()).intValue();
        CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
        if (n3 != n) {
            cIMValue = new CIMValue((Object)new UnsignedInt8((short)n));
            cIMInstance2.setProperty("CPUState", cIMValue);
            bl = true;
        }
        if (n4 != n2) {
            cIMValue = new CIMValue((Object)new UnsignedInt8((short)n2));
            cIMInstance2.setProperty("CPUStatus", cIMValue);
            bl = true;
        }
        if (bl) {
            CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
        }
    }

    protected void updateResLparAssign(int n, String string, CIMObjectPath cIMObjectPath, int n2, String string2) throws CIMException {
        String string3;
        CIMObjectPath cIMObjectPath2;
        Vector vector = CimomWrapper.referenceNames((CIMOMHandle)this.mCIMOMHandle, new CIMObjectPath(string2, "root/ibmhscV3_2"), cIMObjectPath, null);
        boolean bl = false;
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)vector.elementAt(n3);
                cIMObjectPath2 = (CIMObjectPath)this.mCIMOMHandle.getProperty(cIMObjectPath3, "GroupComponent").getValue();
                string3 = (String)this.mCIMOMHandle.getProperty(cIMObjectPath2, "Name").getValue();
                int n4 = Integer.parseInt(string3.substring(0, 3));
                if (n4 == n2) {
                    bl = true;
                } else {
                    CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3);
                }
                ++n3;
            }
        }
        if (!bl && n2 != 0 && n == 8) {
            CIMObjectPath cIMObjectPath4 = HscProviderUtils.slot2cop(n2, string);
            System.out.println("destCop: " + cIMObjectPath4);
            int n5 = ((UnsignedInt8)this.mCIMOMHandle.getProperty(cIMObjectPath4, _PARTITION_STATE).getValue()).intValue();
            if (n5 != 8) {
                return;
            }
            cIMObjectPath2 = new CIMObjectPath(string2, "root/ibmhscV3_2");
            string3 = this.mCIMOMHandle.getClass(cIMObjectPath2, false);
            CIMInstance cIMInstance = string3.newInstance();
            cIMInstance.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath4));
            cIMInstance.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath));
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CimomWrapper.createInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance);
        }
    }

    protected void procOncCPUChange(CIMObjectPath cIMObjectPath, String string, int n, int n2, int n3, int n4, String string2, HscProviderSocket hscProviderSocket) throws CIMException {
        CIMObjectPath cIMObjectPath2 = this._getCpuCop(n, string);
        CIMInstance cIMInstance = this.getCpuInst(cIMObjectPath2);
        if (n3 == 16 || n3 == 0) {
            if (cIMInstance != null) {
                this._deleteOneCpu((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
            }
            return;
        }
        if (cIMInstance == null) {
            ComputerSystemProvUtils.addCPU((CIMOMHandle)this.mCIMOMHandle, (short)n2, (short)n3, n, cIMObjectPath);
            ComputerSystemProvUtils.allocateProcessor((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMObjectPath2, hscProviderSocket);
            return;
        }
        this.resetCpuStateStatue(n2, n3, cIMObjectPath2, cIMInstance);
        this.updateResLparAssign(n2, string, cIMObjectPath2, n4, "IBMHSC_AllocatedProcessor");
    }

    protected CIMInstance getCpuInst(CIMObjectPath cIMObjectPath) {
        try {
            return CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_Processor"), false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private Vector getAllCpuAssignment(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
    }

    private Vector getAllCpuStates(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_STATE");
    }

    private Vector getAllCpuStatus(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSORS_STATUS_VALUES", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_STATUS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardwareMemory30(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        CIMObjectPath cIMObjectPath2 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = this._getCecName(cIMObjectPath);
        try {
            try {
                Vector vector = (Vector)hashtable.get("LPAR_LIST");
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                int n = 0;
                while (n < vector.size()) {
                    Integer n2 = (Integer)vector.elementAt(n);
                    cIMObjectPath2 = this._slot2cop(n2, string2);
                    CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                    if (cIMInstance == null) {
                        // empty if block
                    }
                    hashtable2 = null;
                    hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(n2)}, hscProviderSocket, string);
                    long l = (Long)hashtable2.get("TOT_ALLOC_MEMORY");
                    cIMInstance.setProperty("AllocatedMemory", new CIMValue((Object)new UnsignedInt32(l)));
                    if (hashtable2 != null) {
                        long l2 = (Long)hashtable2.get("PAGE_TABLE_ALLOC_MEMORY");
                        cIMInstance.setProperty("PageTableMemory", new CIMValue((Object)new UnsignedInt32(l2)));
                    }
                    CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var19_18 = null;
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
            Object var19_17 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void hardwareSlot30(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        Object var4_4 = null;
        CIMObjectPath cIMObjectPath2 = null;
        String string2 = null;
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string3 = this._getCecName(cIMObjectPath);
        Vector vector = null;
        String[] stringArray = new String[1];
        try {
            try {
                block16: {
                    block15: {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
                        vector = (Vector)hashtable.get("SLOT_LIST");
                        if (vector == null) break block15;
                        if (vector.size() != 0) break block16;
                    }
                    Object var20_12 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                string2 = (String)hashtable.get("DRAWER_ID");
                System.out.println("drawerId: " + string2);
                stringArray[0] = string2;
                cIMObjectPath2 = this._getDrawerCop(string2, string3);
                hashtable2 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", stringArray, hscProviderSocket, string);
                Hashtable hashtable3 = (Hashtable)hashtable2.get("SLOT_INFORMATION");
                int n = 0;
                while (n < vector.size()) {
                    Integer n2 = (Integer)vector.elementAt(n);
                    CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(n2.shortValue()));
                    Hashtable hashtable4 = (Hashtable)hashtable3.get(new Integer(n2 - 1));
                    System.out.println("process slot " + n2);
                    if (hashtable4 == null) {
                        System.out.println("slot " + n2 + " is not in drawer " + string2);
                    } else {
                        CIMObjectPath cIMObjectPath3 = this._getPCISlotCop(cIMValue, string2, string3);
                        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_PCISlot"), false);
                        if (cIMInstance == null) {
                            System.out.println("slot " + string2 + "/" + n2 + " is not in CIMOM ");
                        } else {
                            this.resetIOStateStatus(cIMObjectPath3, cIMInstance, hashtable4);
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var20_14 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var20_15 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var20_13 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    private Properties getClassCodeProp() throws CIMException {
        if (mClassCodeProp == null) {
            mClassCodeProp = this.getPropFromFile("/opt/hsc/data/HscPciClassCodeInfo");
        }
        return mClassCodeProp;
    }

    private Properties getVendorCodeProp() throws CIMException {
        if (mVendorCodeProp == null) {
            mVendorCodeProp = this.getPropFromFile("/opt/hsc/data/HSCVendorLookUp");
        }
        return mVendorCodeProp;
    }

    private Properties getPropFromFile(String string) throws CIMException {
        try {
            Properties properties = new Properties();
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = " The Properties File HscPciClassCodeInfo is not available";
            fileNotFoundException.printStackTrace();
            throw new CIMException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(" IOError : Failed during the Properties  Initialization of the class code.");
            iOException.printStackTrace();
            throw new CIMException(iOException.getMessage());
        }
        catch (Exception exception) {
            System.out.println(" excep in initization of class  code property file... but Continue!!!");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            throw new CIMException(exception.getMessage());
        }
    }

    protected void resetIOStateStatus(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, Hashtable hashtable) throws CIMException {
        String string;
        boolean bl = false;
        System.out.println("########## old slot instance " + cIMInstance);
        System.out.println("slotInfo: " + hashtable);
        CIMValue cIMValue = cIMInstance.getProperty("PCISlotStatus").getValue();
        CIMValue cIMValue2 = cIMInstance.getProperty("State").getValue();
        CIMValue cIMValue3 = cIMInstance.getProperty("ClassCode").getValue();
        CIMValue cIMValue4 = new CIMValue((Object)((String)hashtable.get("PCI_CLASS_CODE")));
        CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
        if (CimomWrapper.setProperty(cIMInstance2, "PCISlotStatus", new UnsignedInt8(((Integer)hashtable.get("IO_STATUS")).shortValue()))) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance2, "State", new UnsignedInt8(((Integer)hashtable.get("IO_STATE")).shortValue()))) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance2, "ClassCode", string = (String)hashtable.get("PCI_CLASS_CODE"))) {
            bl = true;
        }
        Properties properties = this.getClassCodeProp();
        String string2 = null;
        if (properties != null) {
            string2 = (String)properties.get(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        Integer n = (Integer)hashtable.get("DEVICE_ID");
        Integer n2 = (Integer)hashtable.get("VENDOR_ID");
        if (n == 65535 && n2 == 65535) {
            string2 = "Empty";
        }
        if (CimomWrapper.setProperty(cIMInstance2, "DeviceId", new UnsignedInt16(n.intValue()))) {
            bl = true;
        }
        if (CimomWrapper.setProperty(cIMInstance2, "VendorID", new UnsignedInt16(n2.intValue()))) {
            bl = true;
        }
        if (CimomWrapper.setPropertyString(cIMInstance2, "ClassCodeInfo", string2)) {
            bl = true;
        }
        long l = (Long)hashtable.get("DRC_INDEX");
        System.out.println("The DRCIndex value is :" + l);
        if (CimomWrapper.setProperty(cIMInstance2, "DRCIndex", new UnsignedInt32(l))) {
            bl = true;
        }
        System.out.println("################# new slot inst: " + cIMInstance2);
        if (bl) {
            CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
        }
    }

    private void hardwareEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = (Integer)hashtable.get("PROC_CHANGE");
        if (n == 1) {
            this.hardwareCpu(hashtable, cIMObjectPath, string);
            return;
        }
        int n2 = (Integer)hashtable.get("MEMORY_CHANGE");
        if (n2 == 1) {
            return;
        }
        int n3 = (Integer)hashtable.get("IO_DRAWER_CHANGE");
        switch (n3) {
            case 1: {
                this.hardwareSlot(hashtable, cIMObjectPath);
                break;
            }
            case 2: {
                this.hardwareDrawerAdd(hashtable, cIMObjectPath);
                break;
            }
            case 3: {
                this.hardwareDrawerDelete(hashtable, cIMObjectPath, string);
            }
        }
    }

    private void cuodCapacityEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block11: {
            try {
                int n;
                int n2;
                if (IDebug.enabled) {
                    System.out.println("MKS: Inside cuodCapacityEvent");
                }
                int n3 = (Integer)hashtable.get("PROC_CHANGE");
                int n4 = (Integer)hashtable.get("PROC_ACTIVATE_IMM_STATE");
                if (IDebug.enabled) {
                    System.out.println("MKS: procChange, " + n3 + " procActImmedChange ," + n4);
                }
                if (n3 == 1 || n4 == 1) {
                    if (IDebug.enabled) {
                        System.out.println("MKS: Changing processor resources");
                    }
                    this.hardwareCpu(hashtable, cIMObjectPath, string);
                    this._cuodResourceChange(CUOD_CPU_CHANGE, hashtable, cIMObjectPath, string);
                }
                int n5 = (Integer)hashtable.get("MEMORY_CHANGE");
                int n6 = (Integer)hashtable.get("MEM_ACTIVATE_IMM_STATE");
                if (IDebug.enabled) {
                    System.out.println("MKS: memChange, " + n5 + " memActImmedChange ," + n6);
                }
                if (n5 == 1 || n6 == 1) {
                    if (IDebug.enabled) {
                        System.out.println("MKS: Changing memory resources");
                    }
                    this.hardwareMem(hashtable, cIMObjectPath, string);
                    this._cuodResourceChange(CUOD_MEM_CHANGE, hashtable, cIMObjectPath, string);
                }
                if ((n2 = ((Integer)hashtable.get("HACKING_EVENT")).intValue()) == 1) {
                    this._displayCUoDMessage(CUOD_HACKING_MSG, hashtable, cIMObjectPath, string);
                }
                if ((n = ((Integer)hashtable.get("DECRYPTION_RETURN_CODE")).intValue()) != 0) {
                    this._updateCUoDKeyStatus(n, hashtable, cIMObjectPath, string);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block11;
                throwable.printStackTrace();
            }
        }
    }

    private void onoffCapacityEvent(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block11: {
            try {
                System.out.println("MKS: Inside onoffCapacityEvent");
                int n = (Integer)hashtable.get("PROC_CHANGE");
                System.out.println("MKS: procChange, " + n);
                int n2 = (Integer)hashtable.get("ONOFF_PROC_CHANGE");
                System.out.println("MKS: onOff state Change, " + n2);
                Integer n3 = (Integer)hashtable.get("HACKING_EVENT");
                boolean bl = false;
                if (n3 != null) {
                    n3.intValue();
                }
                if (bl) {
                    this._displayCUoDMessage(CUOD_HACKING_MSG, hashtable, cIMObjectPath, string);
                }
                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                int n4 = ((UnsignedInt8)cIMInstance.getProperty(_CEC_MODE).getValue().getValue()).intValue();
                if (n == 1) {
                    System.out.println("MKS: Setting CUoDResourceInitStatus");
                    this._cuodResourceChange(ONOFF_PROC_CHANGE, hashtable, cIMObjectPath, string);
                    System.out.println("MKS: Setting OnOffResourceInitStatus");
                    this._onoffResourceChange(ONOFF_PROC_CHANGE, hashtable, cIMObjectPath, string);
                    if (n4 != 0) break block11;
                    CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                    CIMInstance cIMInstance3 = cIMInstance2.filterProperties(null, true, true);
                    System.out.println("MKS: SENDING Asynch Event");
                    AsynchEventManager.sendIndication(128, cIMInstance3, cIMInstance2);
                    break block11;
                }
                if (n2 == 1 || n2 == 4) {
                    String string2;
                    String string3 = "";
                    System.out.println("MKS: Received on/off proc state change");
                    if (n2 == 1) {
                        System.out.println("MKS: received activation state");
                        string3 = "Invalid message in On/Off COD";
                        string2 = (String)this.mCIMOMHandle.getProperty(cIMObjectPath, "Name").getValue();
                        if (n4 == 0) {
                            string3 = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_SMP_ACTIVATION_MESSAGE", "In order to use the requested processors for the managed system {0} you need to 'power off' and 'power on'", new String[]{string2});
                        } else if (n4 == 255) {
                            string3 = HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_LPAR_ACTIVATION_MESSAGE", "Processor days are accumulating for managed system {0}.  Please assign the requested processors to partitions.", new String[]{string2});
                        }
                    } else {
                        return;
                    }
                    string2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                    CIMInstance cIMInstance4 = string2.filterProperties(null, true, true);
                    cIMInstance4.setProperty("AsyncMsg", new CIMValue((Object)string3));
                    AsynchEventManager.sendIndication(64, cIMInstance4, (CIMInstance)string2);
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0 && !IDebug.enabled) break block11;
                throwable.printStackTrace();
            }
        }
    }

    private void displayMessage(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        System.out.println("###############3displayMessage");
        this._displayCUoDMessage(CUOD_DISPLAY_MSG, hashtable, cIMObjectPath, string);
    }

    private void broadcastCec(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        n = (Integer)hashtable.get("BROADCAST_EVENT");
        System.out.println("broadcastEvent: " + n);
        switch (n) {
            case 1: {
                this.broadcastCecTty(hashtable, cIMObjectPath);
                break;
            }
            case 2: {
                this.broadcastCecPolicy(hashtable, cIMObjectPath, string);
                break;
            }
            case 4: {
                this.broadcastCecName(hashtable, cIMObjectPath, string);
            }
        }
    }

    private void broadcastLpar(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        n = (Integer)hashtable.get("BROADCAST_EVENT");
        System.out.println("broadcastEvent: " + n);
        switch (n) {
            case 1: {
                this.broadcastLparCreate(hashtable, cIMObjectPath, string);
                break;
            }
            case 2: {
                this.broadcastLparDelete(hashtable, cIMObjectPath, string);
                break;
            }
            case 4: {
                this.broadcastLparName(hashtable, cIMObjectPath, string);
                break;
            }
            case 8: {
                this.broadcastLparTty(hashtable, cIMObjectPath);
                break;
            }
            case 16: {
                this.broadcastLparActivate(hashtable, cIMObjectPath, string);
                break;
            }
            case 32: {
                this.broadcastLparResAssign(hashtable, cIMObjectPath, string);
            }
        }
    }

    private void broadcastLparProfile(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        n = (Integer)hashtable.get("BROADCAST_EVENT");
        System.out.println("broadcastEvent: " + n);
        switch (n) {
            case 1: {
                this.broadcastLparProfileCreate(hashtable, cIMObjectPath);
                break;
            }
            case 2: {
                this.broadcastLparProfileDelete(hashtable, cIMObjectPath);
                break;
            }
            case 4: {
                this.broadcastLparProfileModify(hashtable, cIMObjectPath, string);
                break;
            }
            case 8: {
                this.broadcastLparProfileDefault(hashtable, cIMObjectPath);
            }
        }
    }

    private void broadcastSysProfile(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        n = (Integer)hashtable.get("BROADCAST_EVENT");
        System.out.println("broadcastEvent: " + n);
        switch (n) {
            case 1: {
                this.broadcastSysProfileCreate(hashtable, cIMObjectPath);
                break;
            }
            case 2: {
                this.broadcastSysProfileDelete(hashtable, cIMObjectPath, string);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.broadcastSysProfileUpdate(hashtable, cIMObjectPath);
            }
        }
    }

    private void broadcastCecTty(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        block4: {
            int n = -1;
            int n2 = -1;
            CIMInstance cIMInstance = null;
            CIMInstance cIMInstance2 = null;
            CIMValue cIMValue = null;
            Hashtable hashtable2 = null;
            String string = this._getCecName(cIMObjectPath);
            n2 = (Integer)hashtable.get("COUNT");
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                n = ((UnsignedInt8)cIMInstance.getProperty("VirtualTTYWindowCount").getValue().getValue()).intValue();
                if (n == n2) {
                    return;
                }
                Vector vector = (Vector)hashtable2.get("LIST_SESSION_NUMBERS");
                n2 = vector.size();
                if (n2 == n) {
                    return;
                }
                cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n2));
                cIMInstance2.setProperty("VirtualTTYWindowCount", cIMValue);
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block4;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastCecPolicy(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastCecPolicy");
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMValue cIMValue = null;
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = this._getCecName(cIMObjectPath);
        n = (Integer)hashtable.get("POWER_POLICY");
        switch (n) {
            case 0: {
                n2 = (Integer)hashtable.get("POWER_SETTING");
                try {
                    try {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                        cIMValue = cIMInstance.getProperty("PowerOffPolicy").getValue();
                        n3 = cIMValue.equals((Object)CIMValue.TRUE) ? 1 : 0;
                        if (n3 == n2) {
                            Object var15_13 = null;
                            if (hscProviderSocket == null) return;
                            hscProviderSocket.releaseLock();
                            return;
                        }
                        String string3 = "1";
                        hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_POLICY_SETTINGS", new String[]{string3}, hscProviderSocket, string);
                        n2 = (Integer)hashtable2.get("POWER_POLICY");
                        if (n2 == n3) {
                            Object var15_14 = null;
                            if (hscProviderSocket == null) return;
                            hscProviderSocket.releaseLock();
                            return;
                        }
                        cIMValue = n2 == 1 ? CIMValue.TRUE : CIMValue.FALSE;
                        cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                        cIMInstance2.setProperty("PowerOffPolicy", cIMValue);
                        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            throwable.printStackTrace();
                        }
                        Object var15_16 = null;
                        if (hscProviderSocket == null) return;
                        hscProviderSocket.releaseLock();
                        return;
                    }
                    Object var15_15 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    if (hscProviderSocket == null) throw throwable;
                    hscProviderSocket.releaseLock();
                    throw throwable;
                }
            }
            case 1: {
                n2 = (Integer)hashtable.get("POWER_SETTING");
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                    cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                    if (CimomWrapper.setProperty(cIMInstance2, "CspSurveillancePolicy", new UnsignedInt16(n2))) {
                        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                    }
                    AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                    return;
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    throwable.printStackTrace();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastCecName(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket;
        block9: {
            block8: {
                String string2 = null;
                String string3 = null;
                CIMInstance cIMInstance = null;
                CIMInstance cIMInstance2 = null;
                CIMValue cIMValue = null;
                Hashtable hashtable2 = null;
                hscProviderSocket = null;
                String string4 = this._getCecName(cIMObjectPath);
                string3 = (String)hashtable.get("CEC_NAME");
                try {
                    try {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string4);
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                        string2 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                        if (string2.equals(string3)) {
                            Object var14_12 = null;
                            if (hscProviderSocket == null) return;
                            hscProviderSocket.releaseLock();
                            return;
                        }
                        hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_NAME", null, hscProviderSocket, string);
                        string3 = (String)hashtable2.get("CEC_NAME");
                        if (string2.equals(string3)) {
                            break block8;
                        }
                        cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                        cIMValue = new CIMValue((Object)string3);
                        cIMInstance2.setProperty("UserDefinedName", cIMValue);
                        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            throwable.printStackTrace();
                        }
                        Object var14_15 = null;
                        if (hscProviderSocket == null) return;
                        hscProviderSocket.releaseLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (hscProviderSocket == null) throw throwable;
                    hscProviderSocket.releaseLock();
                    throw throwable;
                }
            }
            Object var14_13 = null;
            if (hscProviderSocket == null) return;
            hscProviderSocket.releaseLock();
            return;
        }
        Object var14_14 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastLparCreate(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var7_7 = null;
        HscProviderSocket hscProviderSocket = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastLparCreate.");
        }
        String string2 = this._getCecName(cIMObjectPath);
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
        n = (Integer)hashtable.get("LPAR_ID");
        cIMObjectPath2 = this._slot2cop(n, string2);
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cIMInstance != null) {
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     Found lpar " + n + " already in cimom. Exiting.");
                        System.out.println("     the lparInst is " + cIMInstance);
                    }
                    Object var13_13 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                cIMInstance = this._addCimLpar((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string2, n, cIMObjectPath2, nVRAM, hscProviderSocket, string);
                AsynchEventManager.sendIndication(1, cIMInstance, null);
            }
            catch (Throwable throwable) {
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                Object var13_15 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var13_14 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastLparDelete(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var7_7 = null;
        HscProviderSocket hscProviderSocket = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastLparDelete.");
        }
        String string2 = this._getCecName(cIMObjectPath);
        n = (Integer)hashtable.get("LPAR_ID");
        cIMObjectPath2 = this._slot2cop(n, string2);
        try {
            try {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                                if (cIMInstance == null) {
                                    Object var16_10 = null;
                                    if (hscProviderSocket == null) return;
                                    hscProviderSocket.releaseLock();
                                    return;
                                }
                                OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string2);
                                opPanelPoller.setMaxPollFreq(n, -1);
                                try {
                                    this._delReferences((CIMOMHandle)this.mCIMOMHandle, "IBMHSC_AllocatedProcessor", cIMObjectPath2);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    if (GlobalConfig.debugLevel((int)6) <= 0) break block20;
                                    throwable.printStackTrace();
                                }
                            }
                            try {
                                this._delReferences((CIMOMHandle)this.mCIMOMHandle, "IBMHSC_AllocatedSlot", cIMObjectPath2);
                            }
                            catch (Throwable throwable) {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                if (GlobalConfig.debugLevel((int)6) <= 0) break block21;
                                throwable.printStackTrace();
                            }
                        }
                        try {
                            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
                            Enumeration enumeration = CimomWrapper.associatorNames((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3, cIMObjectPath2, null, "Element", "Setting").elements();
                            while (enumeration.hasMoreElements()) {
                                try {
                                    CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                                    CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath4, new CIMClass("IBMHSC_LparProfile"), false);
                                    this._delCimLparProf((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath4);
                                    AsynchEventManager.sendIndication(2, cIMInstance2, null);
                                }
                                catch (Throwable throwable) {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                    if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                                    throwable.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            if (GlobalConfig.debugLevel((int)6) <= 0) break block22;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        this._delReferences((CIMOMHandle)this.mCIMOMHandle, "IBMHSC_CompSysPartition", cIMObjectPath2);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) <= 0) break block23;
                        throwable.printStackTrace();
                    }
                }
                CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                AsynchEventManager.sendIndication(2, cIMInstance, null);
            }
            catch (Throwable throwable) {
                String string3;
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                if ((string3 = throwable.getMessage()) != null && !string3.equals("CIM_ERR_NOT_FOUND")) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                Object var16_12 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var16_11 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastLparName(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket;
        block9: {
            block8: {
                int n = -1;
                String string2 = null;
                String string3 = null;
                CIMInstance cIMInstance = null;
                CIMInstance cIMInstance2 = null;
                CIMValue cIMValue = null;
                Hashtable hashtable2 = null;
                hscProviderSocket = null;
                CIMObjectPath cIMObjectPath2 = null;
                String string4 = this._getCecName(cIMObjectPath);
                n = (Integer)hashtable.get("LPAR_ID");
                cIMObjectPath2 = this._slot2cop(n, string4);
                string3 = (String)hashtable.get("LPAR_NAME");
                try {
                    try {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string4);
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                        string2 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                        if (string2.equals(string3)) {
                            Object var16_14 = null;
                            if (hscProviderSocket == null) return;
                            hscProviderSocket.releaseLock();
                            return;
                        }
                        String string5 = Integer.toHexString(n);
                        hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_NAME", new String[]{string5}, hscProviderSocket, string);
                        string3 = (String)hashtable2.get("LPAR_NAME");
                        if (string2.equals(string3)) {
                            break block8;
                        }
                        cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                        cIMValue = new CIMValue((Object)string3);
                        cIMInstance2.setProperty("UserDefinedName", cIMValue);
                        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance2);
                        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            throwable.printStackTrace();
                        }
                        Object var16_17 = null;
                        if (hscProviderSocket == null) return;
                        hscProviderSocket.releaseLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    if (hscProviderSocket == null) throw throwable;
                    hscProviderSocket.releaseLock();
                    throw throwable;
                }
            }
            Object var16_15 = null;
            if (hscProviderSocket == null) return;
            hscProviderSocket.releaseLock();
            return;
        }
        Object var16_16 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    private void broadcastLparTty(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        block4: {
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            CIMInstance cIMInstance = null;
            CIMInstance cIMInstance2 = null;
            CIMValue cIMValue = null;
            CIMObjectPath cIMObjectPath2 = null;
            Hashtable hashtable2 = null;
            String string = this._getCecName(cIMObjectPath);
            n = (Integer)hashtable.get("LPAR_ID");
            cIMObjectPath2 = this._slot2cop(n, string);
            n3 = (Integer)hashtable.get("COUNT");
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                n2 = ((UnsignedInt8)cIMInstance.getProperty("VirtualTTYWindowCount").getValue().getValue()).intValue();
                if (n2 == n3) {
                    return;
                }
                String string2 = Integer.toHexString(n);
                Vector vector = (Vector)hashtable2.get("LIST_SESSION_NUMBERS");
                n3 = vector.size();
                if (n3 == n2) {
                    return;
                }
                cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n3));
                cIMInstance2.setProperty("VirtualTTYWindowCount", cIMValue);
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block4;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void broadcastLparActivate(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        HscProviderSocket hscProviderSocket;
        block15: {
            block13: {
                int n = -1;
                CIMInstance cIMInstance = null;
                CIMInstance cIMInstance2 = null;
                CIMObjectPath cIMObjectPath2 = null;
                CIMObjectPath cIMObjectPath3 = null;
                CIMObjectPath cIMObjectPath4 = null;
                Hashtable hashtable2 = null;
                hscProviderSocket = null;
                String string2 = null;
                String string3 = this._getCecName(cIMObjectPath);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("In AsynchEventHandler.broadcastLparActivate.");
                }
                try {
                    try {
                        CIMObjectPath cIMObjectPath5;
                        block14: {
                            n = (Integer)hashtable.get("LPAR_ID");
                            cIMObjectPath2 = this._slot2cop(n, string3);
                            string2 = (String)hashtable.get("LPAR_PROFILE_ID");
                            hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
                            String string4 = Integer.toHexString(n);
                            hashtable2 = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", new String[]{string4}, hscProviderSocket, string);
                            int n2 = (Integer)hashtable2.get("LPAR_STATE");
                            if (n2 == 1 || n2 == 13 || n2 == 252) {
                                OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string3);
                                opPanelPoller.setMaxPollFreq(n, -1);
                                Object var22_20 = null;
                                if (hscProviderSocket == null) return;
                                hscProviderSocket.releaseLock();
                                return;
                            }
                            if (n2 == 12) {
                                OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string3);
                                opPanelPoller.setMaxPollFreq(n, 60);
                                break block13;
                            }
                            OpPanelPoller opPanelPoller = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string3);
                            opPanelPoller.setMaxPollFreq(n, 60);
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
                            Vector<CIMInstance> vector = new Vector<CIMInstance>(0);
                            vector.add(cIMInstance);
                            ComputerSystemProvUtils.addAllocateLparResources((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, vector, hscProviderSocket);
                            cIMObjectPath5 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
                            try {
                                Enumeration enumeration = CimomWrapper.referenceNames((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath5, cIMObjectPath2, null).elements();
                                CIMObjectPath cIMObjectPath6 = null;
                                while (enumeration.hasMoreElements()) {
                                    cIMObjectPath6 = (CIMObjectPath)enumeration.nextElement();
                                    CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath6);
                                }
                            }
                            catch (Throwable throwable) {
                                if (GlobalConfig.debugLevel((int)6) <= 0) break block14;
                                throwable.printStackTrace();
                            }
                        }
                        cIMInstance2 = this.mCIMOMHandle.getClass(cIMObjectPath5, false).newInstance();
                        cIMObjectPath3 = this._getLparProfCop(string3, n, string2);
                        cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath2));
                        cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath3));
                        cIMObjectPath4 = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
                        CimomWrapper.createInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath4, cIMInstance2);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            System.out.println("     the actProfCop is " + cIMObjectPath4);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            throwable.printStackTrace();
                        }
                        Object var22_23 = null;
                        if (hscProviderSocket == null) return;
                        hscProviderSocket.releaseLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var22_24 = null;
                    if (hscProviderSocket == null) throw throwable;
                    hscProviderSocket.releaseLock();
                    throw throwable;
                }
            }
            Object var22_21 = null;
            if (hscProviderSocket == null) return;
            hscProviderSocket.releaseLock();
            return;
        }
        Object var22_22 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    private void broadcastLparResAssign(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastLparResAssign.");
        }
        try {
            String string2 = this._getCecName(cIMObjectPath);
            int n = (Integer)hashtable.get("SRC_LPAR_ID");
            System.out.println("lparSlot: " + n);
            int n2 = (Integer)hashtable.get("DST_LPAR_ID");
            System.out.println("destLparSlot: " + n2);
            CIMObjectPath cIMObjectPath2 = null;
            if (n2 > 0) {
                cIMObjectPath2 = this._slot2cop(n2, string2);
            }
            Vector vector = (Vector)hashtable.get("RESOURCE_ELEMENT_IDS");
            System.out.println("resIds.size(): " + vector.size());
            String string3 = (String)hashtable.get("DRAWER_ID");
            System.out.println("drawerId: " + string3);
            int n3 = (Integer)hashtable.get("RESOURCE_TYPE");
            System.out.println("resType: " + n3);
            int n4 = DLPARUtils.getOperType(n, n2);
            System.out.println("opType: " + n4);
            int n5 = 0;
            while (n5 < vector.size()) {
                int n6 = (Integer)vector.elementAt(n5);
                System.out.println("resId[" + n5 + "]: " + n6);
                if (n3 == 2) {
                    DLPARUtils.updateIOAssocs(n4, n6, string3, string2, n, cIMObjectPath2, this.mCIMOMHandle);
                } else if (n3 == 0) {
                    DLPARUtils.updateCPUAssocs(n4, n6, string2, n, cIMObjectPath2, this.mCIMOMHandle);
                }
                ++n5;
            }
        }
        catch (Throwable throwable) {
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastLparProfileCreate(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        int n = -1;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var6_6 = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        boolean bl = false;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastLparProfileCreat.");
        }
        String string2 = this._getCecName(cIMObjectPath);
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
        n = (Integer)hashtable.get("LPAR_ID");
        string = (String)hashtable.get("LPAR_PROFILE_ID");
        cIMObjectPath2 = this._getLparProfCop(string2, n, string);
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cIMInstance != null) {
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("     Found lparProfInst already in cimom. Exiting.");
                    System.out.println("     the lparProfInst is " + cIMInstance);
                }
                return;
            }
            CIMObjectPath cIMObjectPath3 = this._slot2cop(n, string2);
            bl = this.lockCsp(hscProviderSocket, 10);
            Vector vector = nVRAM.getLPARProfile(string, hscProviderSocket);
            if (bl) {
                bl = false;
                this.unlockCsp(hscProviderSocket);
            }
            if (vector == null) {
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("     the lparProf " + string + " is no longer in CSP. Exiting.");
                }
                return;
            }
            Vector<Vector> vector2 = new Vector<Vector>(0);
            vector2.add(vector);
            ComputerSystemProvUtils.addLparProfile((CIMOMHandle)this.mCIMOMHandle, this._slot2cop(n, string2), vector2, hscProviderSocket);
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            AsynchEventManager.sendIndication(1, cIMInstance, null);
        }
        catch (Throwable throwable) {
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastLparProfileDelete(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        int n = -1;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var6_6 = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        String string2 = this._getCecName(cIMObjectPath);
        boolean bl = false;
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
        n = (Integer)hashtable.get("LPAR_ID");
        string = (String)hashtable.get("LPAR_PROFILE_ID");
        cIMObjectPath2 = this._getLparProfCop(string2, n, string);
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            if (cIMInstance == null) {
                return;
            }
            bl = this.lockCsp(hscProviderSocket, 10);
            Vector vector = nVRAM.getLPARProfile(string, hscProviderSocket);
            if (bl) {
                bl = false;
                this.unlockCsp(hscProviderSocket);
            }
            if (vector == null) {
                this._delCimLparProf((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                AsynchEventManager.sendIndication(2, cIMInstance, null);
            }
        }
        catch (Throwable throwable) {
            String string3;
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
            if ((string3 = throwable.getMessage()) != null && !string3.equals("CIM_ERR_NOT_FOUND")) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void broadcastLparProfileModify(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = null;
        String string3 = this._getCecName(cIMObjectPath);
        boolean bl = false;
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string3);
        n = (Integer)hashtable.get("LPAR_ID");
        string2 = (String)hashtable.get("LPAR_PROFILE_ID");
        cIMObjectPath2 = this._getLparProfCop(string3, n, string2);
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
            cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            String string4 = HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle);
            bl = this.lockCsp(hscProviderSocket, 10);
            Vector vector = nVRAM.getLPARProfile(string2, hscProviderSocket);
            if (bl) {
                bl = false;
                this.unlockCsp(hscProviderSocket);
            }
            if (vector == null) {
                if (cIMInstance2 == null) return;
                try {
                    CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                    AsynchEventManager.sendIndication(2, cIMInstance2, null);
                    return;
                }
                catch (Throwable throwable) {
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    if (GlobalConfig.debugLevel((int)6) <= 0) return;
                    throwable.printStackTrace();
                }
                return;
            }
            if (cIMInstance2 != null) {
                this._delCimLparProf((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
            }
            Vector<Vector> vector2 = new Vector<Vector>(0);
            vector2.add(vector);
            ComputerSystemProvUtils.addLparProfile((CIMOMHandle)this.mCIMOMHandle, this._slot2cop(n, string3), vector2, hscProviderSocket);
            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            if (cIMInstance2 != null) {
                AsynchEventManager.sendIndication(4, cIMInstance, cIMInstance2);
                return;
            } else {
                AsynchEventManager.sendIndication(1, cIMInstance, null);
            }
            return;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            if (GlobalConfig.debugLevel((int)6) <= 0) return;
            throwable.printStackTrace();
            return;
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastLparProfileDefault(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        block35: {
            int n = -1;
            CIMInstance cIMInstance = null;
            CIMInstance cIMInstance2 = null;
            CIMInstance cIMInstance3 = null;
            CIMInstance cIMInstance4 = null;
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            CIMObjectPath cIMObjectPath4 = null;
            CIMObjectPath cIMObjectPath5 = null;
            CIMObjectPath cIMObjectPath6 = null;
            CIMObjectPath cIMObjectPath7 = null;
            HscProviderSocket hscProviderSocket = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            CIMInstance cIMInstance5 = null;
            boolean bl = false;
            if (GlobalConfig.debugLevel((int)6) > 0) {
                System.out.println("In AsynchEventHandler.broadcastLparProfileDefault");
            }
            String string4 = this._getCecName(cIMObjectPath);
            NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string4);
            n = (Integer)hashtable.get("LPAR_ID");
            string = (String)hashtable.get("LPAR_PROFILE_ID");
            try {
                block36: {
                    hscProviderSocket = ProviderLceCommunication.obtainSocket(string4);
                    cIMObjectPath2 = this._slot2cop(n, string4);
                    cIMObjectPath7 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
                    Enumeration enumeration = CimomWrapper.references((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath7, cIMObjectPath2, "Element", false, false, null).elements();
                    Hashtable<String, CIMInstance> hashtable2 = new Hashtable<String, CIMInstance>();
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        string3 = null;
                        cIMInstance4 = (CIMInstance)enumeration.nextElement();
                        if (cIMInstance4 != null) {
                            cIMObjectPath4 = (CIMObjectPath)cIMInstance4.getProperty("Setting").getValue().getValue();
                            string3 = this._profIdFromProfCop(cIMObjectPath4);
                        }
                        if (string3 == null) continue;
                        if (!string3.equals(string)) {
                            hashtable2.put(string3, cIMInstance4);
                            continue;
                        }
                        cIMInstance5 = cIMInstance4;
                    }
                    if (cIMInstance5 != null && hashtable2.size() == 0) {
                        return;
                    }
                    string3 = string;
                    string = null;
                    bl = this.lockCsp(hscProviderSocket, 10);
                    Vector vector = nVRAM.getDefaultLPARProfile(n, hscProviderSocket);
                    if (bl) {
                        bl = false;
                        this.unlockCsp(hscProviderSocket);
                    }
                    if (vector != null && hashtable2.get(string = (String)((CIMProperty)vector.get(0)).getValue().getValue()) != null) {
                        if (hashtable2.size() == 1 && cIMInstance5 == null) {
                            return;
                        }
                        if (cIMInstance5 != null) {
                            hashtable2.put(string3, cIMInstance5);
                        }
                        hashtable2.remove(string);
                        string = null;
                    }
                    Enumeration enumeration2 = hashtable2.keys();
                    while (enumeration2 != null && enumeration2.hasMoreElements()) {
                        block34: {
                            string2 = (String)enumeration2.nextElement();
                            cIMInstance4 = (CIMInstance)hashtable2.get(string2);
                            cIMObjectPath5 = new CIMObjectPath(cIMInstance4.getClassName(), cIMInstance4.getKeyValuePairs());
                            cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
                            CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath5);
                            try {
                                AsynchEventManager.sendIndication(2, cIMInstance4, null);
                            }
                            catch (Throwable throwable) {
                                try {
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                                }
                                catch (Throwable throwable2) {
                                    // empty catch block
                                }
                                if (GlobalConfig.debugLevel((int)6) <= 0) break block34;
                                throwable.printStackTrace();
                            }
                        }
                        try {
                            cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath4, new CIMClass("IBMHSC_LparProfile"), false);
                            AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance2.filterProperties(null, true, true));
                        }
                        catch (Throwable throwable) {
                            try {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                            if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                            throwable.printStackTrace();
                        }
                    }
                    if (string == null) break block35;
                    cIMInstance3 = this.mCIMOMHandle.getClass(cIMObjectPath7, false).newInstance();
                    cIMObjectPath3 = this._getLparProfCop(string4, n, string);
                    cIMInstance3.setProperty("Element", new CIMValue((Object)cIMObjectPath2));
                    cIMInstance3.setProperty("Setting", new CIMValue((Object)cIMObjectPath3));
                    cIMObjectPath6 = new CIMObjectPath(cIMInstance3.getClassName(), cIMInstance3.getKeyValuePairs());
                    cIMObjectPath6.setNameSpace("root/ibmhscV3_2");
                    CimomWrapper.createInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath6, cIMInstance3);
                    try {
                        AsynchEventManager.sendIndication(1, cIMInstance3, null);
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        }
                        catch (Throwable throwable4) {
                            // empty catch block
                        }
                        if (GlobalConfig.debugLevel((int)6) <= 0) break block36;
                        throwable.printStackTrace();
                    }
                }
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_LparProfile"), false);
                AsynchEventManager.sendIndication(4, cIMInstance, cIMInstance.filterProperties(null, true, true));
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                catch (Throwable throwable5) {
                    // empty catch block
                }
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
            }
            finally {
                if (bl) {
                    this.unlockCsp(hscProviderSocket);
                }
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSysProfileCreate(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastSysProfileCreate");
        }
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMClass cIMClass = null;
        Object var7_7 = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        String string2 = this._getCecName(cIMObjectPath);
        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string2);
        string = (String)hashtable.get("SYSTEM_PROFILE_ID");
        cIMObjectPath2 = this._getSysProfCop(string);
        cIMClass = new CIMClass("IBMHSC_SystemProfile");
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            try {
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMClass, false);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    if (cIMInstance == null) {
                        System.out.println("     sysProfInst = null");
                    } else {
                        System.out.println("     sysProfInst = " + cIMInstance);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (cIMInstance != null) {
                return;
            }
            bl = this.lockCsp(hscProviderSocket, 10);
            Vector vector = nVRAM.getSysProfile(string, hscProviderSocket);
            if (bl) {
                bl = false;
                this.unlockCsp(hscProviderSocket);
            }
            if (vector != null) {
                ComputerSystemProvUtils.addSystemProfiles((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, vector, false);
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMClass, false);
                AsynchEventManager.sendIndication(1, cIMInstance, null);
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSysProfileDelete(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block21: {
            if (GlobalConfig.debugLevel((int)6) > 0) {
                System.out.println("In AsynchEventHandler.broadcastSysProfileDelete");
            }
            CIMInstance cIMInstance = null;
            CIMObjectPath cIMObjectPath2 = null;
            Object var6_6 = null;
            HscProviderSocket hscProviderSocket = null;
            String string2 = null;
            String string3 = this._getCecName(cIMObjectPath);
            boolean bl = false;
            try {
                block23: {
                    block22: {
                        hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
                        NVRAM nVRAM = (NVRAM)NVRAM.NVRAM_TABLE.get(string3);
                        string2 = (String)hashtable.get("SYSTEM_PROFILE_ID");
                        cIMObjectPath2 = this._getSysProfCop(string2);
                        cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_SystemProfile"), false);
                        if (cIMInstance == null) {
                            return;
                        }
                        String string4 = HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle);
                        bl = this.lockCsp(hscProviderSocket, 10);
                        Vector vector = nVRAM.getSysProfile(string2, hscProviderSocket);
                        if (bl) {
                            bl = false;
                            this.unlockCsp(hscProviderSocket);
                        }
                        if (vector != null) break block21;
                        try {
                            this._delReferences((CIMOMHandle)this.mCIMOMHandle, "IBMHSC_InSysProfile", cIMObjectPath2);
                        }
                        catch (Throwable throwable) {
                            try {
                                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            if (GlobalConfig.debugLevel((int)6) <= 0) break block22;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        this._delReferences((CIMOMHandle)this.mCIMOMHandle, "IBMHSC_CompSysProfile", cIMObjectPath2);
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                        if (GlobalConfig.debugLevel((int)6) <= 0) break block23;
                        throwable.printStackTrace();
                    }
                }
                CimomWrapper.deleteInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                AsynchEventManager.sendIndication(2, cIMInstance, null);
            }
            catch (Throwable throwable) {
                String string5 = throwable.getMessage();
                if (string5 != null && !string5.equals("CIM_ERR_NOT_FOUND")) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
            }
            finally {
                if (bl) {
                    this.unlockCsp(hscProviderSocket);
                }
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSysProfileUpdate(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.broadcastSysProfileRemove");
        }
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        String string2 = this._getCecName(cIMObjectPath);
        boolean bl = false;
        string = (String)hashtable.get("SYSTEM_PROFILE_ID");
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            CIMObjectPath cIMObjectPath2 = this._getSysProfCop(string);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_SystemProfile"), false);
            SystemProfUpdater systemProfUpdater = new SystemProfUpdater((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance, null);
            bl = this.lockCsp(hscProviderSocket, 10);
            systemProfUpdater.update(hscProviderSocket);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string3 = throwable.getMessage();
            if (string3 != null && !string3.equals("CIM_ERR_NOT_FOUND")) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            }
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
        }
        finally {
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardwareCpu(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = null;
        boolean bl = false;
        String string3 = this._getCecName(cIMObjectPath);
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
                hashtable2 = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket, string);
                Vector vector = (Vector)hashtable2.get("ALL_PROC_STATE");
                int n5 = vector.size();
                int n6 = 0;
                while (n6 < n5) {
                    block22: {
                        cIMInstance = null;
                        string2 = Integer.toHexString(n6);
                        try {
                            hashtable2 = HscProviderUtils.doCSPCommand("GET_PROC_STATUS", new String[]{string2}, hscProviderSocket, string);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            if (GlobalConfig.debugLevel((int)6) > 0) {
                                throwable.printStackTrace();
                            }
                            break block22;
                        }
                        n4 = (Integer)hashtable2.get("PROC_STATUS");
                        cIMObjectPath2 = this._getCpuCop(n6, string3);
                        try {
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Processor"), false);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (n4 == 16 || n4 == 0) {
                            if (cIMInstance != null) {
                                this._deleteOneCpu((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                            }
                        } else if (cIMInstance == null) {
                            ComputerSystemProvUtils.addCPU((CIMOMHandle)this.mCIMOMHandle, (short)n2, (short)n4, n6, cIMObjectPath);
                            ComputerSystemProvUtils.allocateProcessor((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMObjectPath2, hscProviderSocket);
                        } else {
                            n = ((UnsignedInt8)cIMInstance.getProperty("CPUState").getValue().getValue()).intValue();
                            n3 = ((UnsignedInt8)cIMInstance.getProperty("CPUStatus").getValue().getValue()).intValue();
                            n2 = (Integer)vector.elementAt(n6);
                            if (n != n2) {
                                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n2));
                                cIMInstance.setProperty("CPUState", cIMValue);
                                bl = true;
                            }
                            if (n3 != n4) {
                                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n4));
                                cIMInstance.setProperty("CPUStatus", cIMValue);
                                bl = true;
                            }
                            if (bl) {
                                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance);
                            }
                        }
                    }
                    ++n6;
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var21_24 = null;
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
            Object var21_23 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardwareSlot(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        Object var3_3 = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var5_5 = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        String string2 = this._getCecName(cIMObjectPath);
        string = (String)hashtable.get("DRAWER_ID");
        cIMObjectPath2 = this._getDrawerCop(string, string2);
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                this._deleteOneDrawer((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                ComputerSystemProvUtils.addDrawerAndSlots((CIMOMHandle)this.mCIMOMHandle, string, cIMObjectPath, hscProviderSocket);
                ComputerSystemProvUtils.allocateDrawer((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var11_10 = null;
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
            Object var11_9 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hardwareMem(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = this._getCecName(cIMObjectPath);
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, hscProviderSocket, string);
                long l = (Long)hashtable2.get("MEMORY_INSTALLED");
                long l2 = (Long)hashtable2.get("TOT_AVAILABLE_MEMORY");
                long l3 = (Long)hashtable2.get("FAILED_MEMORY");
                long l4 = (Long)hashtable2.get("REGION_SIZE");
                long l5 = l2 - l3;
                cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                cIMInstance2.setProperty("LMBSize", new CIMValue((Object)new UnsignedInt32(l4)));
                cIMInstance2.setProperty("InstalledMemory", new CIMValue((Object)new UnsignedInt32(l)));
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                cIMObjectPath2 = this._getMemCop(string2);
                cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Memory"), false);
                cIMInstance.setProperty("TotalMemory", new CIMValue((Object)new UnsignedInt32(l)));
                cIMInstance.setProperty("FreeMemory", new CIMValue((Object)new UnsignedInt32(l2)));
                cIMInstance.setProperty("UsableMemory", new CIMValue((Object)new UnsignedInt32(l5)));
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMInstance);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var21_17 = null;
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
            }
            Object var21_16 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var21_18 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void hardwareDrawerAdd(Hashtable hashtable, CIMObjectPath cIMObjectPath) {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var5_5 = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.hardwareDrawerAdd.");
        }
        String string2 = this._getCecName(cIMObjectPath);
        string = (String)hashtable.get("DRAWER_ID");
        cIMObjectPath2 = this._getDrawerCop(string, string2);
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_IODrawer"), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cIMInstance != null) {
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     found the drawer " + cIMObjectPath2);
                    }
                    Object var11_11 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                ComputerSystemProvUtils.addDrawerAndSlots((CIMOMHandle)this.mCIMOMHandle, string, cIMObjectPath, hscProviderSocket);
                ComputerSystemProvUtils.allocateDrawer((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string, hscProviderSocket);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("     leaving AsynchEventHandler.hardwareDrawerAdd");
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var11_13 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var11_12 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void hardwareDrawerDelete(Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        Hashtable hashtable2 = null;
        HscProviderSocket hscProviderSocket = null;
        String string2 = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler.hardwareDrawerDelete.");
        }
        String string3 = this._getCecName(cIMObjectPath);
        string2 = (String)hashtable.get("DRAWER_ID");
        cIMObjectPath2 = this._getDrawerCop(string2, string3);
        try {
            try {
                hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
                try {
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_IODrawer"), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (cIMInstance == null) {
                    Object var13_13 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
                try {
                    hashtable2 = HscProviderUtils.doCSPCommand("GET_IO_DRAWER_INFO", new String[]{string2}, hscProviderSocket, string);
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     found the drawer in csp.");
                    }
                }
                catch (HSCCIMException hSCCIMException) {
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     exception for getting i/o info");
                        hSCCIMException.printStackTrace();
                    }
                    this._deleteOneDrawer((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2);
                    Object var13_15 = null;
                    if (hscProviderSocket == null) return;
                    hscProviderSocket.releaseLock();
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                Object var13_16 = null;
                if (hscProviderSocket == null) return;
                hscProviderSocket.releaseLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (hscProviderSocket == null) throw throwable;
            hscProviderSocket.releaseLock();
            throw throwable;
        }
        Object var13_14 = null;
        if (hscProviderSocket == null) return;
        hscProviderSocket.releaseLock();
    }

    private Hashtable _readAPacket(byte[] byArray, String string) {
        Integer n = null;
        ParseResponse parseResponse = null;
        Hashtable hashtable = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._readAPacket");
        }
        try {
            parseResponse = new ParseResponse(byArray, string);
            hashtable = parseResponse.getAsyncData();
            if (hashtable == null || hashtable.isEmpty()) {
                return null;
            }
            n = (Integer)hashtable.get("ASYNC_STATUS_OPCODE");
            if (n != 5 && n != 105) {
                return null;
            }
            return hashtable;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private String _getCecName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("Name")) {
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
            ++n;
        }
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._getCecName(). cecName = " + string);
        }
        return string;
    }

    private boolean _isCSPV1V2(CIMObjectPath cIMObjectPath) throws HSCCIMException {
        int n = VersionComparator.CSPVersionValue(this._getCspVersion(cIMObjectPath));
        return n < 3000;
    }

    private String _getCspVersion(CIMObjectPath cIMObjectPath) {
        try {
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
            return (String)cIMInstance.getProperty(_CSP_VERSION).getValue().getValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private String _profIdFromProfCop(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._profIdFromProfCop");
        }
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("SettingID")) {
                string = (String)cIMProperty.getValue().getValue();
                break;
            }
            ++n;
        }
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("     lparProfId = " + string);
        }
        return string;
    }

    private String _lparSlotFromLparCop(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._lparSlotFromLparCop");
        }
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("Name")) {
                string = ((String)cIMProperty.getValue().getValue()).substring(0, 3);
                break;
            }
            ++n;
        }
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("     lparSlot = " + string);
        }
        return string;
    }

    private CIMObjectPath _slot2cop(int n, String string) {
        CIMObjectPath cIMObjectPath = null;
        String string2 = String.valueOf(n);
        int n2 = string2.length();
        while (n2 < 3) {
            string2 = "0" + string2;
            ++n2;
        }
        string2 = string2 + "*" + string;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string2));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        return cIMObjectPath;
    }

    private CIMObjectPath _getLparProfCop(String string, int n, String string2) {
        CIMObjectPath cIMObjectPath = null;
        String string3 = String.valueOf(n);
        int n2 = string3.length();
        while (n2 < 3) {
            string3 = "0" + string3;
            ++n2;
        }
        string3 = string3 + "*" + string;
        cIMObjectPath = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
        cIMObjectPath.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        cIMObjectPath.addKey("PartitionName", new CIMValue((Object)string3));
        cIMObjectPath.addKey("SettingID", new CIMValue((Object)string2));
        return cIMObjectPath;
    }

    private CIMObjectPath _getSysProfCop(String string) {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_SystemProfile", "root/ibmhscV3_2");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        return cIMObjectPath;
    }

    private CIMObjectPath _getInSysProfCop(String string, int n, String string2, String string3) {
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = this._getSysProfCop(string);
        CIMObjectPath cIMObjectPath3 = this._getLparProfCop(string3, n, string2);
        cIMObjectPath = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
        cIMObjectPath.addKey("Context", new CIMValue((Object)cIMObjectPath2));
        cIMObjectPath.addKey("Setting", new CIMValue((Object)cIMObjectPath3));
        return cIMObjectPath;
    }

    private CIMObjectPath _getCpuCop(int n, String string) {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Processor", "root/ibmhscV3_2");
        cIMObjectPath.addKey("DeviceID", new CIMValue((Object)new UnsignedInt8((short)n)));
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)string));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Processor"));
        return cIMObjectPath;
    }

    private CIMObjectPath _getDrawerCop(String string, String string2) {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_IODrawer", "root/ibmhscV3_2");
        cIMObjectPath.addKey("DeviceID", new CIMValue((Object)string));
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)string2));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
        return cIMObjectPath;
    }

    private CIMObjectPath _getPCISlotCop(CIMValue cIMValue, String string, String string2) {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", "root/ibmhscV3_2");
        cIMObjectPath.addKey("IODrawerDeviceID", new CIMValue((Object)string));
        cIMObjectPath.addKey("IODrawerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("IODrawerSystemName", new CIMValue((Object)string2));
        cIMObjectPath.addKey("IODrawerCreationClassName", new CIMValue((Object)"IBMHSC_IODrawer"));
        cIMObjectPath.addKey("SlotID", cIMValue);
        return cIMObjectPath;
    }

    private CIMObjectPath _getMemCop(String string) {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Memory", "root/ibmhscV3_2");
        cIMObjectPath.addKey("DeviceID", new CIMValue((Object)"Mem00"));
        cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
        cIMObjectPath.addKey("SystemName", new CIMValue((Object)string));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Memory"));
        return cIMObjectPath;
    }

    private void _delReferences(CIMOMHandle cIMOMHandle, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._delReferences. reference is " + string);
        }
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string, "root/ibmhscV3_2");
        Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            try {
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                throwable.printStackTrace();
            }
        }
    }

    private CIMInstance _handleErrState(CIMInstance cIMInstance, int n, HscProviderSocket hscProviderSocket, String string) throws CIMException {
        CIMInstance cIMInstance2;
        block9: {
            cIMInstance2 = null;
            int n2 = -1;
            short s = -1;
            Hashtable hashtable = null;
            String[] stringArray = new String[2];
            String string2 = Integer.toHexString(n);
            hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_BOOT_ERROR_VALUES", new String[]{string2}, hscProviderSocket, string);
            s = ((Integer)hashtable.get("BOOT_ERROR")).shortValue();
            try {
                n2 = ((UnsignedInt8)cIMInstance.getProperty("BootErrorValue").getValue().getValue()).shortValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n2 != s) {
                cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(s));
                cIMInstance2.setProperty("BootErrorValue", cIMValue);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
                cIMObjectPath.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    System.out.println("    newLparInst = " + cIMInstance2);
                }
            }
            try {
                if (n != 0 && s != 0 && s != 172) {
                    stringArray[0] = string2;
                    stringArray[1] = Integer.toHexString(11);
                    HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", stringArray, hscProviderSocket, string);
                }
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                if (GlobalConfig.debugLevel((int)6) <= 0) break block9;
                throwable.printStackTrace();
            }
        }
        return cIMInstance2;
    }

    private CIMInstance _updateOneLparState(CIMInstance cIMInstance, short s) throws CIMException {
        CIMInstance cIMInstance2 = null;
        short s2 = -1;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("in AsynchEventHandler._updateOneLparState");
        }
        try {
            s2 = ((UnsignedInt8)cIMInstance.getProperty(_PARTITION_STATE).getValue().getValue()).shortValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (s2 != s) {
            cIMInstance2 = cIMInstance.filterProperties(null, true, true);
            CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(s));
            cIMInstance2.setProperty(_PARTITION_STATE, cIMValue);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance2.getClassName(), cIMInstance2.getKeyValuePairs());
            cIMObjectPath.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            if (GlobalConfig.debugLevel((int)6) > 0) {
                System.out.println("    newLparInst = " + cIMInstance2);
            }
        }
        return cIMInstance2;
    }

    private void _updateCecLparState(CIMObjectPath cIMObjectPath, short s, boolean bl) {
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        int n = -1;
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("In AsynchEventHandler._updateCecLparState");
        }
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMObjectPath, null, null, null).elements();
            while (enumeration.hasMoreElements()) {
                try {
                    cIMInstance2 = null;
                    CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                    if (!bl && this._lparSlotFromLparCop(cIMObjectPath3).equals(_FMP_SLOT)) continue;
                    cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3, this.mCIMOMHandle.getClass(cIMObjectPath3, false), false);
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("oldLparPath = " + cIMObjectPath3);
                        System.out.println("oldLparInst = " + cIMInstance);
                        System.out.println("key values = " + cIMInstance.getKeyValuePairs());
                    }
                    cIMInstance2 = this._updateOneLparState(cIMInstance, s);
                }
                catch (Throwable throwable) {
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        throwable.printStackTrace();
                    }
                    try {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                if (cIMInstance2 == null) continue;
                AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
            }
        }
        catch (Throwable throwable) {
            if (GlobalConfig.debugLevel((int)6) > 0) {
                throwable.printStackTrace();
            }
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
        }
    }

    private void _updateAvailState(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, CIMObjectPath cIMObjectPath2, HscProviderSocket hscProviderSocket, String string2) {
        block17: {
            String string3 = null;
            float f = 0.0f;
            CIMInstance cIMInstance = null;
            Hashtable hashtable = null;
            int n = -1;
            CIMInstance cIMInstance2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            CIMClass cIMClass = null;
            if (GlobalConfig.debugLevel((int)6) > 0) {
                System.out.println("In AsynchEventHandler._updateAvailState()");
            }
            try {
                cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                string3 = (String)cIMInstance.getProperty(_CSP_VERSION).getValue().getValue();
                f = Float.parseFloat(string3.substring(1));
                if (f < 2.0f) {
                    _cecPartModes.put(string, new Integer(1));
                    return;
                }
                hashtable = HscProviderUtils.doCSPCommand("GET_CEC_CAPABILITY_MODE", null, hscProviderSocket, string2);
                n = ((Integer)hashtable.get("MODE")).shortValue();
                if (n != 255) {
                    return;
                }
                hashtable = HscProviderUtils.doCSPCommand("GET_PARTITION_MODE", null, hscProviderSocket, string2);
                n4 = ((Integer)hashtable.get("MODE")).shortValue();
                if (n4 == 0) {
                    return;
                }
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
                Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath4, cIMObjectPath, null, null, null).elements();
                cIMClass = new CIMClass("IBMHSC_Partition");
                while (enumeration.hasMoreElements()) {
                    try {
                        CIMInstance cIMInstance3 = null;
                        cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                        cIMInstance3 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath3, cIMClass, false);
                        n2 = ((UnsignedInt8)cIMInstance3.getProperty(_PARTITION_TYPE).getValue().getValue()).shortValue();
                        n3 = ((UnsignedInt8)cIMInstance3.getProperty(_PARTITION_STATE).getValue().getValue()).shortValue();
                        CIMValue cIMValue = null;
                        if (n4 == n2) {
                            if (n3 == 252) {
                                cIMValue = new CIMValue((Object)new UnsignedInt8(1));
                            }
                        } else if (n3 != 252) {
                            cIMValue = new CIMValue((Object)new UnsignedInt8(252));
                        }
                        if (cIMValue == null) continue;
                        cIMInstance2 = cIMInstance3.filterProperties(null, true, true);
                        cIMInstance2.setProperty(_PARTITION_STATE, cIMValue);
                        CimomWrapper.setInstance(cIMOMHandle, cIMObjectPath3, cIMInstance2);
                        if (CimomWrapper.sameObjectPath(cIMObjectPath3, cIMObjectPath2)) continue;
                        AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance3);
                    }
                    catch (Throwable throwable) {
                        try {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                        throwable.printStackTrace();
                    }
                }
                _cecPartModes.put(string, new Integer(n4));
            }
            catch (Throwable throwable) {
                try {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                if (GlobalConfig.debugLevel((int)6) <= 0) break block17;
                throwable.printStackTrace();
            }
        }
    }

    private void _deleteOneDrawer(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        HscProviderUtils.deleteSlotsOfDrawer(cIMObjectPath, cIMOMHandle, true);
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysIODrawer", "root/ibmhscV3_2");
        Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            try {
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
            catch (Throwable throwable) {
                if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                throwable.printStackTrace();
            }
        }
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
    }

    private void _deleteOneCpu(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) {
        block14: {
            block13: {
                Enumeration enumeration;
                CIMObjectPath cIMObjectPath2;
                CIMObjectPath cIMObjectPath3;
                block12: {
                    cIMObjectPath3 = null;
                    cIMObjectPath2 = null;
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysProcessor", "root/ibmhscV3_2");
                    try {
                        enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
                        while (enumeration.hasMoreElements()) {
                            cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                            try {
                                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
                            }
                            catch (Throwable throwable) {
                                if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                                throwable.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) <= 0) break block12;
                        throwable.printStackTrace();
                    }
                }
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
                try {
                    enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
                    while (enumeration.hasMoreElements()) {
                        cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                        try {
                            CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
                        }
                        catch (Throwable throwable) {
                            if (GlobalConfig.debugLevel((int)6) <= 0) continue;
                            throwable.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    if (GlobalConfig.debugLevel((int)6) <= 0) break block13;
                    throwable.printStackTrace();
                }
            }
            try {
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block14;
                throwable.printStackTrace();
            }
        }
    }

    private void _delCimLparProf(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath) throws CIMException {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            System.out.println("In AsynchEventHandler._delCimLparProf.");
                        }
                        try {
                            this._delReferences(cIMOMHandle, "IBMHSC_InSysProfile", cIMObjectPath);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                            if (GlobalConfig.debugLevel((int)6) <= 0) break block9;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        this._delReferences(cIMOMHandle, "IBMHSC_ActivatedLparProfile", cIMObjectPath);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                        if (GlobalConfig.debugLevel((int)6) <= 0) break block10;
                        throwable.printStackTrace();
                    }
                }
                try {
                    this._delReferences(cIMOMHandle, "IBMHSC_DefaultLparProfile", cIMObjectPath);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    if (GlobalConfig.debugLevel((int)6) <= 0) break block11;
                    throwable.printStackTrace();
                }
            }
            try {
                this._delReferences(cIMOMHandle, "IBMHSC_PartitionProfile", cIMObjectPath);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block12;
                throwable.printStackTrace();
            }
        }
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMInstance _addCimLpar(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, String string, int n, CIMObjectPath cIMObjectPath2, NVRAM nVRAM, HscProviderSocket hscProviderSocket, String string2) throws CIMException {
        Object object;
        short s;
        CIMInstance cIMInstance;
        block18: {
            int n2;
            cIMInstance = null;
            if (GlobalConfig.debugLevel((int)6) > 0) {
                System.out.println("In AsynchEventHandler._addCimLpar.");
            }
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket, string2);
            int n3 = (Integer)hashtable.get("CEC_STATE");
            cIMInstance = ComputerSystemProvUtils.addPartitions(cIMOMHandle, cIMObjectPath, nVRAM, n, false, hscProviderSocket, n3, n2 = ((Integer)(hashtable = HscProviderUtils.doCSPCommand("GET_CEC_CAPABILITY_MODE", null, hscProviderSocket, string2)).get("MODE")).intValue());
            if (cIMInstance == null) {
                throw new HSCCIMException((String)null);
            }
            boolean bl = false;
            try {
                try {
                    bl = this.lockCsp(hscProviderSocket, 10);
                    Vector vector = nVRAM.getLPARProfilesAtPartition((short)n, hscProviderSocket);
                    if (bl) {
                        bl = false;
                        this.unlockCsp(hscProviderSocket);
                    }
                    ComputerSystemProvUtils.addLparProfile(cIMOMHandle, cIMObjectPath2, vector, hscProviderSocket);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        throwable.printStackTrace();
                    }
                    Object var16_18 = null;
                    if (bl) {
                        this.unlockCsp(hscProviderSocket);
                    }
                }
                Object var16_17 = null;
                if (bl) {
                    this.unlockCsp(hscProviderSocket);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                if (bl) {
                    this.unlockCsp(hscProviderSocket);
                }
                throw throwable;
            }
            s = ((UnsignedInt8)cIMInstance.getProperty(_PARTITION_STATE).getValue().getValue()).shortValue();
            if (s == 8) {
                try {
                    object = new Vector<CIMInstance>(0);
                    ((Vector)object).add(cIMInstance);
                    ComputerSystemProvUtils.addAllocateLparResources(cIMOMHandle, cIMObjectPath, (Vector)object, hscProviderSocket);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    if (GlobalConfig.debugLevel((int)6) <= 0) break block18;
                    throwable.printStackTrace();
                }
            }
        }
        if (s == 1 || s == 13 || s == 252) {
            object = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string);
            ((OpPanelPoller)object).setMaxPollFreq(n, -1);
        } else if (s == 8 || s == 5 || s == 9 || s == 12) {
            object = (OpPanelPoller)OpPanelPoller.OP_POLLER_TABLE.get(string);
            ((OpPanelPoller)object).setMaxPollFreq(n, 60);
        }
        return cIMInstance;
    }

    private void _cuodResourceChange(int n, Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block3: {
            try {
                if (IDebug.enabled) {
                    System.out.println("MKS: Setting CUoDResource init Status to '1'");
                }
                short s = 1;
                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMInstance2.setProperty("CUoDResourceInitStatus", new CIMValue((Object)new UnsignedInt8(s)));
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block3;
                throwable.printStackTrace();
            }
        }
    }

    private void _onoffResourceChange(int n, Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block2: {
            try {
                System.out.println("MKS: Setting OnOff Resource init Status to '1'");
                short s = 1;
                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMInstance2.setProperty("OnOffResourceInitStatus", new CIMValue((Object)new UnsignedInt8(s)));
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block2;
                throwable.printStackTrace();
            }
        }
    }

    private void _displayCUoDMessage(int n, Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block14: {
            try {
                String string2 = "";
                if (n == CUOD_HACKING_MSG) {
                    string2 = HSCResourceBundleUtil.getMessage("CUoDNewMessages", "0000", "");
                }
                if (n == CUOD_DISPLAY_MSG) {
                    String string3;
                    Object object;
                    int n2 = (Integer)hashtable.get("MESSAGE_ID");
                    int n3 = (Integer)hashtable.get("MESSAGE_TYPE");
                    int n4 = (Integer)hashtable.get("MESSAGE_DESTINATION");
                    Vector vector = (Vector)hashtable.get("PARAMETERS_LIST");
                    if (IDebug.enabled) {
                        System.out.println("*** Message ID: " + n2);
                        System.out.println("*** Message Type: " + n3);
                        System.out.println("*** Message Dest: " + n4);
                        System.out.println("*** Params size: " + vector.size());
                        int n5 = 0;
                        while (n5 < vector.size()) {
                            System.out.println("** PARAM " + n5 + ":" + (String)vector.elementAt(n5));
                            ++n5;
                        }
                    }
                    if ((n4 & 1) != 0) {
                        String string4 = this.getIDFromShort((short)n2);
                        if (IDebug.enabled) {
                            System.out.println("Message Destn: 1 - Message String: " + string4);
                        }
                        string2 = vector != null && vector.size() != 0 ? HSCResourceBundleUtil.getMessage("CUoDNewMessages", string4, "", vector.toArray(new String[vector.size()])) : HSCResourceBundleUtil.getMessage("CUoDNewMessages", string4, "");
                    }
                    if ((n4 & 2) != 0) {
                        String string5 = (String)this.mCIMOMHandle.getProperty(cIMObjectPath, "Name").getValue();
                        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
                        object = CimomWrapper.associatorNames((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, cIMObjectPath, null, null, null).elements();
                        while (object.hasMoreElements()) {
                            string3 = (CIMObjectPath)object.nextElement();
                            String string6 = (String)this.mCIMOMHandle.getProperty((CIMObjectPath)string3, "Name").getValue();
                            String string7 = string6.substring(0, string6.indexOf(42));
                            SendMsgThruRMC sendMsgThruRMC = null;
                            sendMsgThruRMC = vector != null && vector.size() != 0 ? new SendMsgThruRMC(string5, string7, n2, vector.toArray(new String[vector.size()]), 0, 0) : new SendMsgThruRMC(string5, string7, n2, null, 0, 0);
                            sendMsgThruRMC.start();
                        }
                    }
                    if ((n4 & 4) != 0) {
                        String string8 = this._getCecName(cIMObjectPath);
                        int n6 = string8.indexOf("*");
                        object = string8.substring(0, n6++);
                        string3 = string8.substring(n6);
                        if (vector != null && vector.size() != 0) {
                            RMCUtils.makeCUoDSE((String)object, string3, "CUoDNewMessages", "" + this.getIDFromShort((short)n2), vector.toArray(new String[vector.size()]));
                        } else {
                            RMCUtils.makeCUoDSE((String)object, string3, "CUoDNewMessages", "" + this.getIDFromShort((short)n2), null);
                        }
                    }
                    System.out.println("asynchMsg = " + string2);
                }
                if (!string2.equals("")) {
                    CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                    CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                    cIMInstance2.setProperty("AsyncMsg", new CIMValue((Object)string2));
                    AsynchEventManager.sendIndication(32, cIMInstance2, cIMInstance);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block14;
                throwable.printStackTrace();
            }
        }
    }

    private void _updateCUoDKeyStatus(int n, Hashtable hashtable, CIMObjectPath cIMObjectPath, String string) {
        block2: {
            try {
                CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
                cIMInstance2.setProperty("CUoDActivateStatus", new CIMValue((Object)new UnsignedInt8((short)n)));
                CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block2;
                throwable.printStackTrace();
            }
        }
    }

    private boolean lockCsp(HscProviderSocket hscProviderSocket, int n) throws CIMException {
        while (n > -1) {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toString(1), HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (hashtable != null) {
                return true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void unlockCsp(HscProviderSocket hscProviderSocket) {
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toString(2), HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private String getIDFromShort(short s) {
        short s2 = (short)(s & 0xFFFF);
        int n = 4;
        while ((s2 & 0xF) != 0) {
            s2 = (short)(s2 >> 4);
            --n;
        }
        String string = "";
        while (n != 0) {
            string = string + "0";
            --n;
        }
        string = string + Integer.toString(s, 16);
        return string;
    }

    private String getMessage(String string) {
        return HSCResourceBundleUtil.getMessage("CECBundle", string);
    }

    static {
        if (GlobalConfig.debugLevel((int)6) > 0) {
            System.out.println("Loading AsynchEventHandler");
        }
        _cecPartModes = new Hashtable();
    }
}

